/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.util.Hashtable;

public class Tuner
extends Applet
implements Runnable {
    TNet tnet;
    Knob kc1;
    Knob kc2;
    Knob kl;
    Meter mswr;
    AutoTune at;
    double c1max = 250.0;
    double c2max = 250.0;
    double elmax = 30.0;
    double qc1 = 2000.0;
    double qc2 = 2000.0;
    double qel = 100.0;
    double f;
    double z1r;
    double z1i;
    double z2r;
    double z2i;
    double z3r;
    double z3i;
    double zlr;
    double zli;
    DBLabel lossl;
    DBLabel dblossl;
    DBLabel swrl;
    TextField tinfo;
    TextField tzlr;
    TextField tzlx;
    TextField tf;
    Button bauto;
    Button bsetup;
    MyPanel pupperleft;
    MyPanel pload;
    MyPanel pinfo;
    MyPanel psetup;
    TextField tc1max;
    TextField tc2max;
    TextField telmax;
    TextField tc1q;
    TextField tc2q;
    TextField telq;
    Button bok;
    Button bcancel;
    Color bcolor;
    Thread calcthread;

    public void init() {
        this.at = new AutoTune();
        this.bcolor = new Color(100, 150, 100);
        this.setBackground(this.bcolor);
        this.setLayout(new GridLayout(2, 3, 10, 10));
        this.pinfo = new MyPanel();
        this.pinfo.setLayout(new GridLayout(6, 2));
        this.pinfo.add(new Label("SWR ="));
        this.swrl = new DBLabel("");
        this.pinfo.add(this.swrl);
        this.pinfo.add(new Label("Percent Loss ="));
        this.lossl = new DBLabel("");
        this.pinfo.add(this.lossl);
        this.pinfo.add(new Label("dB Loss ="));
        this.dblossl = new DBLabel("");
        this.pinfo.add(this.dblossl);
        this.bauto = new Button("Autotune");
        this.pinfo.add(this.bauto);
        this.tinfo = new TextField("");
        this.pinfo.add(this.tinfo);
        this.bsetup = new Button("Set Up");
        this.pinfo.add(this.bsetup);
        this.pinfo.add(new Label(""));
        this.pinfo.add(new Label(""));
        this.pinfo.add(new Label(""));
        this.pupperleft = new MyPanel();
        this.pupperleft.setLayout(new CardLayout());
        this.add(this.pupperleft);
        this.pupperleft.add("Info", this.pinfo);
        this.psetup = new MyPanel();
        this.psetup.setLayout(new GridLayout(7, 2));
        this.psetup.add(new Label("C1 Max (pF) ="));
        this.tc1max = new TextField(Truncate.toString(this.c1max, 1));
        this.psetup.add(this.tc1max);
        this.psetup.add(new Label("C1 Q ="));
        this.tc1q = new TextField(Truncate.toString(this.qc1, 1));
        this.psetup.add(this.tc1q);
        this.psetup.add(new Label("L Max (microH) ="));
        this.telmax = new TextField(Truncate.toString(this.elmax, 1));
        this.psetup.add(this.telmax);
        this.psetup.add(new Label("L Q ="));
        this.telq = new TextField(Truncate.toString(this.qel, 1));
        this.psetup.add(this.telq);
        this.psetup.add(new Label("C2 Max (pF) ="));
        this.tc2max = new TextField(Truncate.toString(this.c2max, 1));
        this.psetup.add(this.tc2max);
        this.psetup.add(new Label("C2 Q ="));
        this.tc2q = new TextField(Truncate.toString(this.qc2, 1));
        this.psetup.add(this.tc2q);
        this.bok = new Button("OK");
        this.psetup.add(this.bok);
        this.bcancel = new Button("Cancel");
        this.psetup.add(this.bcancel);
        this.pupperleft.add("Setup", this.psetup);
        this.mswr = new Meter(0.0, 1.0);
        this.add(this.mswr);
        Hashtable<Double, String> hashtable = new Hashtable<Double, String>(6);
        hashtable.put(new Double(0.0), new String("1.0"));
        hashtable.put(new Double(0.2), new String("1.5"));
        hashtable.put(new Double(0.3333333333333333), new String("2.0"));
        hashtable.put(new Double(0.5), new String("3.0"));
        hashtable.put(new Double(0.8), new String("9.0"));
        hashtable.put(new Double(1.0), new String(""));
        this.mswr.setScale(hashtable);
        this.mswr.setLabel("SWR");
        this.pload = new MyPanel();
        this.pload.setLayout(new GridLayout(6, 2));
        this.pload.add(new Label("R Load = "));
        this.tzlr = new TextField("10", 8);
        this.pload.add(this.tzlr);
        this.pload.add(new Label("X Load = "));
        this.tzlx = new TextField("0", 8);
        this.pload.add(this.tzlx);
        this.pload.add(new Label("F (MHz) ="));
        this.tf = new TextField("1.83", 8);
        this.pload.add(this.tf);
        this.pload.add(new Label(""));
        this.pload.add(new Label(""));
        this.pload.add(new Label(""));
        this.pload.add(new Label(""));
        this.pload.add(new Label(""));
        this.pload.add(new Label(""));
        this.add(this.pload);
        this.kc1 = new Knob("Input C (pF)", 0.001, this.c1max, 10.0);
        this.add(this.kc1);
        this.kl = new Knob("Coil (microH)", 0.001, this.elmax, 30.0);
        this.add(this.kl);
        this.kc2 = new Knob("Output C (pF)", 0.001, this.c2max, 10.0);
        this.add(this.kc2);
        this.kc1.setValue(0.5 * this.c1max);
        this.kc2.setValue(0.5 * this.c2max);
        this.kl.setValue(0.5 * this.elmax);
        this.pupperleft.setBackground(this.bcolor);
        this.pinfo.setBackground(this.bcolor);
        this.psetup.setBackground(this.bcolor);
        this.bauto.setBackground(this.bcolor);
        this.bok.setBackground(this.bcolor);
        this.bcancel.setBackground(this.bcolor);
        this.bsetup.setBackground(this.bcolor);
        this.tinfo.setBackground(this.bcolor);
        this.tzlr.setBackground(this.bcolor);
        this.tzlx.setBackground(this.bcolor);
        this.tf.setBackground(this.bcolor);
        this.tc1max.setBackground(this.bcolor);
        this.tc2max.setBackground(this.bcolor);
        this.telmax.setBackground(this.bcolor);
        this.tc1q.setBackground(this.bcolor);
        this.tc2q.setBackground(this.bcolor);
        this.telq.setBackground(this.bcolor);
        this.calcZ();
        this.tnet = new TNet(this.z1r, this.z1i, this.z2r, this.z2i, this.z3r, this.z3i, this.zlr, this.zli);
        this.recalc();
        this.validate();
        this.calcthread = new Thread(this);
        this.calcthread.start();
        this.calcthread.suspend();
    }

    private void recalc() {
        double d = this.tnet.getRho();
        double d2 = (1.0 + d) / (1.0 - d);
        this.mswr.setValue(d);
        this.mswr.repaint();
        this.swrl.setText(Truncate.toString(d2, 1));
        double d3 = this.tnet.getLoss();
        this.lossl.setText(Truncate.toString(d3 * 100.0, 1));
        double d4 = -10.0 * Math.log(1.0 - d3) / Math.log(10.0);
        this.dblossl.setText(Truncate.toString(d4, 1));
        this.swrl.repaint();
        this.dblossl.repaint();
        this.lossl.repaint();
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (event.target == this.kc1 || event.target == this.kc2 || event.target == this.kl) {
            this.calcthread.resume();
            Thread.currentThread();
            Thread.yield();
        }
        return true;
    }

    public void run() {
        while (Thread.currentThread() == this.calcthread) {
            this.calcZ();
            this.tnet.setZl(this.zlr, this.zli);
            this.tnet.setZ1(this.z1r, this.z1i);
            this.tnet.setZ2(this.z2r, this.z2i);
            this.tnet.setZ3(this.z3r, this.z3i);
            this.recalc();
            Thread.yield();
            this.calcthread.suspend();
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean calcZLoad() {
        this.zlr = 0.0;
        this.zli = 0.0;
        this.tinfo.setText("");
        try {
            this.zlr = new Double(this.tzlr.getText());
            if (this.zlr <= 0.0) {
                this.tinfo.setText("R Load < 0");
                this.pinfo.repaint();
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.tinfo.setText("R Load Error");
            this.pinfo.repaint();
            return false;
        }
        try {
            this.zli = new Double(this.tzlx.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.tinfo.setText("X Load Error");
            this.pinfo.repaint();
            return false;
        }
        try {
            this.f = new Double(this.tf.getText());
            if (this.f <= 0.0) {
                this.tinfo.setText("F < 0");
                this.pinfo.repaint();
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.tinfo.setText("F error");
            this.pinfo.repaint();
            return false;
        }
        this.zlr *= 0.02;
        this.zli *= 0.02;
        return true;
    }

    private boolean calcZ() {
        if (!this.calcZLoad()) {
            return false;
        }
        double d = this.kc1.getValue();
        double d2 = this.kc2.getValue();
        double d3 = this.kl.getValue();
        double d4 = Math.PI * 2 * this.f * d * 1.0E-6;
        double d5 = d4 / this.qc1;
        double d6 = 1.0 / (d5 * d5 + d4 * d4);
        this.z1r = d5 * d6;
        this.z1i = -d4 * d6;
        d4 = Math.PI * 2 * this.f * d2 * 1.0E-6;
        d5 = d4 / this.qc2;
        d6 = 1.0 / (d5 * d5 + d4 * d4);
        this.z3r = d5 * d6;
        this.z3i = -d4 * d6;
        this.z2i = Math.PI * 2 * this.f * d3;
        this.z2r = this.z2i / this.qel;
        this.z1r *= 0.02;
        this.z1i *= 0.02;
        this.z2r *= 0.02;
        this.z2i *= 0.02;
        this.z3r *= 0.02;
        this.z3i *= 0.02;
        return true;
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.tzlr || event.target == this.tzlx || event.target == this.tf) {
            this.calcZ();
            this.tnet.setZl(this.zlr, this.zli);
            this.tnet.setZ1(this.z1r, this.z1i);
            this.tnet.setZ2(this.z2r, this.z2i);
            this.tnet.setZ3(this.z3r, this.z3i);
            this.recalc();
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.bauto) {
            this.autoTune();
            return true;
        }
        if (event.target == this.bsetup) {
            ((CardLayout)this.pupperleft.getLayout()).show(this.pupperleft, "Setup");
            return true;
        }
        if (event.target == this.bcancel) {
            ((CardLayout)this.pupperleft.getLayout()).show(this.pupperleft, "Info");
            return true;
        }
        if (event.target == this.bok) {
            double d = this.c1max;
            double d2 = this.c2max;
            double d3 = this.elmax;
            double d4 = this.qc1;
            double d5 = this.qc2;
            double d6 = this.qel;
            boolean bl = true;
            try {
                d = new Double(this.tc1max.getText());
                if (d <= 0.0) {
                    this.tc1max.setText("Error");
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.tc1max.setText("Error");
                bl = false;
            }
            try {
                d4 = new Double(this.tc1q.getText());
                if (d4 <= 0.0) {
                    this.tc1q.setText("Error");
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.tc1q.setText("Error");
                bl = false;
            }
            try {
                d2 = new Double(this.tc2max.getText());
                if (d2 <= 0.0) {
                    this.tc2max.setText("Error");
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.tc2max.setText("Error");
                bl = false;
            }
            try {
                d5 = new Double(this.tc2q.getText());
                if (d5 <= 0.0) {
                    this.tc2q.setText("Error");
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.tc2q.setText("Error");
                bl = false;
            }
            try {
                d3 = new Double(this.telmax.getText());
                if (d3 <= 0.0) {
                    this.telmax.setText("Error");
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.telmax.setText("Error");
                bl = false;
            }
            try {
                d6 = new Double(this.telq.getText());
                if (d6 <= 0.0) {
                    this.telq.setText("Error");
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.telq.setText("Error");
                bl = false;
            }
            if (bl) {
                this.c1max = d;
                this.c2max = d2;
                this.elmax = d3;
                this.qc1 = d4;
                this.qc2 = d5;
                this.qel = d6;
                ((CardLayout)this.pupperleft.getLayout()).show(this.pupperleft, "Info");
                this.kc1.setLimits(0.001, this.c1max, 10.0);
                this.kl.setLimits(0.001, this.elmax, 30.0);
                this.kc2.setLimits(0.001, this.c2max, 10.0);
                this.kc1.repaint();
                this.kc2.repaint();
                this.kl.repaint();
            }
            return true;
        }
        return false;
    }

    private void autoTune() {
        this.tinfo.setText("");
        this.at.tune(this.kc1.getValue(), this.kl.getValue(), this.kc2.getValue(), this.c1max, this.elmax, this.c2max, this.qc1, this.qel, this.qc2, this.f, this.zlr, this.zli);
        if (this.at.isTuned()) {
            this.setComponents(this.at.getCin(), this.at.getL(), this.at.getCout());
        } else {
            this.tinfo.setText("Tune Failed");
        }
    }

    private void setComponents(double d, double d2, double d3) {
        this.kc2.setValue(d3);
        this.kc1.setValue(d);
        this.kl.setValue(d2);
        this.calcZ();
        this.tnet.setZ1(this.z1r, this.z1i);
        this.tnet.setZ2(this.z2r, this.z2i);
        this.tnet.setZ3(this.z3r, this.z3i);
        this.recalc();
    }

    public Dimension minimumSize() {
        return new Dimension(600, 400);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public static void main(String[] stringArray) {
        MyFrame myFrame = new MyFrame();
        Tuner tuner = new Tuner();
        myFrame.setLayout(new BorderLayout());
        myFrame.add((Component)tuner, "Center");
        myFrame.setTitle("T-Network Tuner Simulator");
        tuner.init();
        myFrame.pack();
        myFrame.show();
    }

    public String getAppletInfo() {
        return "T-Network Tuner Simulator, version 0.04 Copyright 1999-2003, Kevin E. Schmidt";
    }
}

