/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class Knob
extends Panel {
    private double angle = 0.0;
    private double anglemax;
    private double anglem = 0.0;
    private double valuemin;
    private double valuemax;
    private double value;
    private double turns;
    private Panel p;
    private Graphics gimage;
    private Image image;
    private Image imageback;
    private Dimension dimage;
    private String label;
    private Color knobcolor;
    private int places;
    private int ifont = -1;
    private Font f1;

    public Knob() {
        this("");
    }

    public Knob(String string) {
        this(string, 0.0, 1.0, 1.0);
    }

    public Knob(String string, double d, double d2, double d3) {
        this.valuemin = d;
        this.valuemax = d2;
        this.label = string;
        this.turns = d3;
        this.value = d;
        this.anglemax = Math.PI * 2 * d3;
        this.knobcolor = new Color(80, 20, 20);
        this.places = 1;
    }

    public void setPlaces(int n) {
        this.places = n;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        int n;
        Dimension dimension = this.size();
        if (this.gimage == null || dimension.width != this.dimage.width || dimension.height != this.dimage.height) {
            this.dimage = dimension;
            this.image = this.createImage(this.dimage.width, this.dimage.height);
            this.gimage = this.image.getGraphics();
        }
        if (this.ifont != 12 * (n = Math.min(dimension.width, dimension.height)) / 190) {
            this.ifont = 12 * n / 190;
            this.f1 = new Font("Helvetica", 1, this.ifont);
        }
        this.gimage.setFont(this.f1);
        this.gimage.setColor(this.getBackground());
        this.gimage.fillRect(0, 0, dimension.width, dimension.height);
        this.gimage.setColor(this.knobcolor);
        int n2 = Math.min(dimension.width, dimension.height) / 2;
        int n3 = dimension.width / 2;
        int n4 = dimension.height / 2;
        int n5 = n3 + (int)(-Math.round(Math.cos(this.angle) * (double)n2));
        int n6 = n4 + (int)(-Math.round(Math.sin(this.angle) * (double)n2));
        n2 = (int)((double)n2 * 0.8);
        int n7 = (int)(-Math.round(180.0 * this.angle / Math.PI));
        int n8 = (int)((double)n2 * 1.05);
        int n9 = 0;
        while (n9 < 10) {
            this.gimage.fillArc(n3 - n8, n4 - n8, n8 * 2, n8 * 2, n7 - 36 * n9 - 28, 18);
            ++n9;
        }
        this.gimage.fillOval(n3 - n2, n4 - n2, n2 * 2, n2 * 2);
        this.gimage.setColor(Color.red);
        int n10 = (int)(0.3 * (double)n2);
        int n11 = (int)((double)(n5 - n3) * 0.65 + (double)n3);
        int n12 = (int)((double)(n6 - n4) * 0.65 + (double)n4);
        this.gimage.fillOval(n11 - n10 / 2, n12 - n10 / 2, n10, n10);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.gimage.setColor(this.knobcolor);
        this.gimage.drawString(this.label + " =   " + Truncate.toString(this.value, this.places), 0, dimension.height - 5);
        graphics.drawImage(this.image, 0, 0, null);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        Dimension dimension = this.size();
        int n3 = n - dimension.width / 2;
        int n4 = n2 - dimension.height / 2;
        this.anglem = Math.atan2(n4, n3);
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        Dimension dimension = this.size();
        int n3 = n2 - dimension.height / 2;
        int n4 = n - dimension.width / 2;
        double d = Math.atan2(n3, n4);
        double d2 = d - this.anglem;
        if (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        }
        if (d2 < -Math.PI) {
            d2 += Math.PI * 2;
        }
        this.angle += d2;
        this.angle = Math.max(0.0, Math.min(this.angle, this.anglemax));
        this.value = this.angle / (this.turns * 2.0 * Math.PI) * (this.valuemax - this.valuemin) + this.valuemin;
        this.anglem = d;
        this.repaint();
        return false;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        d = Math.max(this.valuemin, Math.min(this.valuemax, d));
        this.angle = this.turns * 2.0 * Math.PI * ((d - this.valuemin) / (this.valuemax - this.valuemin));
        this.value = d;
        this.repaint();
    }

    public void setLimits(double d, double d2, double d3) {
        this.valuemin = d;
        this.valuemax = d2;
        this.turns = d3;
        this.value = Math.max(d, Math.min(d2, this.value));
        this.anglemax = Math.PI * 2 * d3;
    }
}

